/*
 * jQuery Spritify 2.2.1
 * 
 * [spritify]
 * 
 * NO COPYRIGHTS OR LICENSES. DO WHAT YOU LIKE.
 * 
 * http://digipiph.com
 * 
 * File generated: Fri Apr 5 11:04 EST 2013
 */
(function($){
      
  //START window.spritify()
  window.spritify = function(instanceSettings) {
  	
    //settings
    var defaultSettings = {
      canvas              :        'canvas', //id of the canvas
      width               :              32,
      height              :              32,
      posX                :               0,
      posY                :               0,
      movement            :            true,
      animation           :            true,
      distanceOnPress     :             2.5, //applies if movement is 'true'
      movementType        :          '4dir', //8dir, 4dir, linearLR, linearUD
      image               : 'character.png',
      upControl           :            'up',
      rightControl        :         'right',
      downControl         :          'down',
      leftControl         :          'left',
      upDisableDefault    :            true,
      downDisableDefault  :            true,
      leftDisableDefault  :            true,
      rightDisableDefault :            true,
      FPS                 :              30,
      animationFPS        :               6,
      collisionObjs       :           false
    };

  

    /***********************
    //General Configuring (Global Variables)
    ***********************/

    // get the defaults or any user set options
    var settings = $.extend(defaultSettings, instanceSettings);	

    //define our objects
    var canvasElement = document.getElementById(settings.canvas);
    var canvas = canvasElement.getContext("2d");
    var animationTimer = 0;
    var animationDirection = 0;
    var currentDirection = 0;

    var spritifyObj = {
      width: settings.width,
      height: settings.height,
      x: settings.posX,
      y: settings.posY,
      sprite: Sprite(settings.image),
      spriteFrame: {
        sourceX: 0,
        sourceY: 0
      },
      draw: function() {
        this.sprite.draw(canvas, this.width, this.height, this.spriteFrame.sourceX, this.spriteFrame.sourceY, this.x, this.y);
      },
      update: function() {

        switch(settings.movementType) {
          case"8dir":
            setDirection();
            if (eval('keydown.'+settings.leftControl) && currentDirection == 'left') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.x -= settings.distanceOnPress;
              if (settings.animation) animateSprite('left');
            }
            if (eval('keydown.'+settings.rightControl) && currentDirection == 'right') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.x += settings.distanceOnPress;
              if (settings.animation) animateSprite('right');
            }
            if (eval('keydown.'+settings.upControl) && currentDirection == 'up') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.y -= settings.distanceOnPress;
              if (settings.animation) animateSprite('up');
            }
            if (eval('keydown.'+settings.downControl) && currentDirection == 'down') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.y += settings.distanceOnPress;
              if (settings.animation) animateSprite('down');
            }
            if (eval('keydown.'+settings.leftControl) && eval('keydown.'+settings.upControl) && currentDirection == 'up-left') {
              if (settings.movement && !chkCollisions('left')) spritifyObj.x -= settings.distanceOnPress;
              if (settings.movement && !chkCollisions('up')) spritifyObj.y -= settings.distanceOnPress;
              if (settings.animation) animateSprite('up-left');
            }
            if (eval('keydown.'+settings.rightControl) && eval('keydown.'+settings.upControl) && currentDirection == 'up-right') {
              if (settings.movement && !chkCollisions('right')) spritifyObj.x += settings.distanceOnPress;
              if (settings.movement && !chkCollisions('up')) spritifyObj.y -= settings.distanceOnPress;
              if (settings.animation) animateSprite('up-right');
            }
            if (eval('keydown.'+settings.leftControl) && eval('keydown.'+settings.downControl) && currentDirection == 'down-left') {
              if (settings.movement && !chkCollisions('left')) spritifyObj.x -= settings.distanceOnPress;
              if (settings.movement && !chkCollisions('down')) spritifyObj.y += settings.distanceOnPress;
              if (settings.animation) animateSprite('down-left');
            }
            if (eval('keydown.'+settings.rightControl) && eval('keydown.'+settings.downControl) && currentDirection == 'down-right') {
              if (settings.movement && !chkCollisions('right')) spritifyObj.x += settings.distanceOnPress;
              if (settings.movement && !chkCollisions('down')) spritifyObj.y += settings.distanceOnPress;
              if (settings.animation) animateSprite('down-right');
            }
            break;
          case"4dir":
            setDirection();
            if (eval('keydown.'+settings.leftControl) && currentDirection == 'left') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.x -= settings.distanceOnPress;
              if (settings.animation) animateSprite('left');
            }
            if (eval('keydown.'+settings.rightControl) && currentDirection == 'right') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.x += settings.distanceOnPress;
              if (settings.animation) animateSprite('right');
            }
            if (eval('keydown.'+settings.upControl) && currentDirection == 'up') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.y -= settings.distanceOnPress;
              if (settings.animation) animateSprite('up');
            }
            if (eval('keydown.'+settings.downControl) && currentDirection == 'down') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.y += settings.distanceOnPress;
              if (settings.animation) animateSprite('down');
            }
            break;
          case"linearLR":
            setDirection();
            if (eval('keydown.'+settings.leftControl) && currentDirection == 'left') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.x -= settings.distanceOnPress;
              if (settings.animation) animateSprite('left');
            }
            if (eval('keydown.'+settings.rightControl) && currentDirection == 'right') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.x += settings.distanceOnPress;
              if (settings.animation) animateSprite('right');
            }
            break;
          case"linearUD":
            setDirection();
            if (eval('keydown.'+settings.upControl) && currentDirection == 'up') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.y -= settings.distanceOnPress;
              if (settings.animation) animateSprite('up');
            }
            if (eval('keydown.'+settings.downControl) && currentDirection == 'down') {
              if (settings.movement && !chkCollisions(currentDirection)) spritifyObj.y += settings.distanceOnPress;
              if (settings.animation) animateSprite('down');
            }
            break;
        }
        
        //restrict spriteObj to canvas
        if (spritifyObj.x < 0) spritifyObj.x = 0;
        if (spritifyObj.x > ($(settings.canvas).width() - spritifyObj.width)) spritifyObj.x = ($(settings.canvas).width() - spritifyObj.width);
        if (spritifyObj.y < 0) spritifyObj.y = 0;
        if (spritifyObj.y > ($(settings.canvas).height() - spritifyObj.height)) spritifyObj.y = ($(settings.canvas).height() - spritifyObj.height);

        //increment the animation timer
        animationTimer++;
      }
    };

    function setDirection() {
      if (settings.movementType == '8dir') {
        if (eval('keydown.'+settings.leftControl) && eval('keydown.'+settings.upControl) && !direction) var direction = 'up-left';
        if (eval('keydown.'+settings.rightControl) && eval('keydown.'+settings.upControl) && !direction) var direction = 'up-right';
        if (eval('keydown.'+settings.leftControl) && eval('keydown.'+settings.downControl) && !direction) var direction = 'down-left';
        if (eval('keydown.'+settings.rightControl) && eval('keydown.'+settings.downControl) && !direction) var direction = 'down-right';

        if (eval('keydown.'+settings.leftControl) && !direction) var direction = 'left';
        if (eval('keydown.'+settings.rightControl) && !direction) var direction = 'right';
        if (eval('keydown.'+settings.upControl) && !direction) var direction = 'up';
        if (eval('keydown.'+settings.downControl) && !direction) var direction = 'down';
        if (currentDirection != direction) { currentDirection = direction; }
      }
      else {
        if (eval('keydown.'+settings.leftControl) && !direction) var direction = 'left';
        if (eval('keydown.'+settings.rightControl) && !direction) var direction = 'right';
        if (eval('keydown.'+settings.upControl) && !direction) var direction = 'up';
        if (eval('keydown.'+settings.downControl) && !direction) var direction = 'down';
        if (currentDirection != direction) { currentDirection = direction; }
      }
    }

    function animateSprite(direction) {
      if (animationTimer >= parseInt(settings.FPS/settings.animationFPS) || animationDirection != direction) {

        //set the direction
        animationDirection = direction;

        var sourceX = 0;
        var sourceY = 0;

        //sprite setup
        //down, left, right, up

        //set sourceY
        switch(settings.movementType) {
          case"8dir":
            switch(animationDirection) {
              case'down': sourceY = 0; break;
              case'left': sourceY = settings.height; break;
              case'right': sourceY = parseInt(settings.height * 2); break;
              case'up': sourceY = parseInt(settings.height * 3); break;
              case'down-left': sourceY = parseInt(settings.height * 4); break;
              case'down-right': sourceY = parseInt(settings.height * 5); break;
              case'up-left': sourceY = parseInt(settings.height * 6); break;
              case'up-right': sourceY = parseInt(settings.height * 7); break;
            }
            break;
          case"4dir":
            switch(animationDirection) {
              case'down': sourceY = 0; break;
              case'left': sourceY = settings.height; break;
              case'right': sourceY = parseInt(settings.height * 2); break;
              case'up': sourceY = parseInt(settings.height * 3); break;
            }
            break;
          case"linearLR":
            switch(animationDirection) {
              case'left': sourceY = 0; break;
              case'right': sourceY = settings.height; break;
            }
            break;
          case"linearUD":
            switch(animationDirection) {
              case'down': sourceY = 0; break;
              case'up': sourceY = settings.height; break;
            }
            break;
        }

        //set sourceX
        if ((spritifyObj.spriteFrame.sourceX + settings.width) < spritifyObj.sprite.width) {
          sourceX = parseInt(spritifyObj.spriteFrame.sourceX + settings.width);
        }

        //set the new spritifyObj position
        spritifyObj.spriteFrame.sourceX = sourceX;
        spritifyObj.spriteFrame.sourceY = sourceY;

        //reset timer
        animationTimer = 0;
      }
    }

    /*START: Check Key State*/
    window.keydown = {};
  
    function keyName(event) {
      return jQuery.hotkeys.specialKeys[event.which] ||
        String.fromCharCode(event.which).toLowerCase();
    }
  
    $(document).bind("keydown", function(event) {
      //disable default function for keys
      var ar = Array();
      
      if (settings.upDisableDefault == true) ar[ar.length] = settings.upControl;
      if (settings.downDisableDefault == true) ar[ar.length] = settings.downControl;
      if (settings.leftDisableDefault == true) ar[ar.length] = settings.leftControl;
      if (settings.rightDisableDefault == true) ar[ar.length] = settings.rightControl;

      if ($.inArray(keyName(event),ar) > -1) {
        event.preventDefault();
      }
      keydown[keyName(event)] = true;
    });
  
    $(document).bind("keyup", function(event) {
      keydown[keyName(event)] = false;
    });
    /*END: Check Key State*/

    return { spritifyObj : spritifyObj };

    /*START: Collision Detection*/
    function chkCollisions(currentDirection) {
      if (!settings.collisionObjs) return false;
      if (eval('window.'+settings.collisionObjs).length) {
        for(var x = 0; x < eval('window.'+settings.collisionObjs).length; x++) {
          if (collides(currentDirection, eval('window.'+settings.collisionObjs)[x].spritifyObj, spritifyObj)) {
            return true;
          }
        }
      }
      return false;
    }

    function collides(currentDirection, obj, character) {
      switch(currentDirection) {
        case'up':
          if (obj.x < character.x + character.width 
              && obj.x + obj.width > character.x 
              && obj.y < character.y + character.height - settings.distanceOnPress
              && obj.y + obj.height > character.y - settings.distanceOnPress) return true;
          break;
        case'down':
          if (obj.x < character.x + character.width 
              && obj.x + obj.width > character.x 
              && obj.y < character.y + character.height + settings.distanceOnPress
              && obj.y + obj.height > character.y + settings.distanceOnPress) return true;
          break;
        case'left':
          if (obj.x < character.x + character.width - settings.distanceOnPress
              && obj.x + obj.width > character.x - settings.distanceOnPress
              && obj.y < character.y + character.height
              && obj.y + obj.height > character.y) return true;
          break;
        case'right':
          if (obj.x < character.x + character.width + settings.distanceOnPress
              && obj.x + obj.width > character.x + settings.distanceOnPress
              && obj.y < character.y + character.height
              && obj.y + obj.height > character.y) return true;
          break;
      }
      return false;
    }
    /*END: Collision Detection*/

  };
  //END window.spritify()
  
})(jQuery);



/*Sprite Function*/
//(modified for Spritify's purpose)
//src = http://www.html5rocks.com/en/tutorials/canvas/notearsgame/
(function($) {
  function LoaderProxy() {
    return {
      draw: $.noop,
      fill: $.noop,
      frame: $.noop,
      update: $.noop,
      width: null,
      height: null
    };
  }
  
  function Sprite(image) {    
    return {
      draw: function(canvas, width, height, sourceX, sourceY, x, y) {
        canvas.drawImage(
          image,
          sourceX,
          sourceY,
          width,
          height,
          x,
          y,
          width,
          height
        );
      },
      
      fill: function(canvas, x, y, width, height, repeat) {
        repeat = repeat || "repeat";
        var pattern = canvas.createPattern(image, repeat);
        canvas.fillColor(pattern);
        canvas.fillRect(x, y, width, height);
      },
      
      width: image.width,
      height: image.height
    };
  };
  
  Sprite.load = function(url, loadedCallback) {
    var img = new Image();
    var proxy = LoaderProxy();
    
    img.onload = function() {
      var tile = Sprite(this);
      
      $.extend(proxy, tile);
      
      if(loadedCallback) {
        loadedCallback(proxy);
      }
    };
    
    img.src = url;
    
    return proxy;
  };
 
  window.Sprite = function(spriteImagePath, callback) {
    return Sprite.load(spriteImagePath, callback);
  };
  window.Sprite.EMPTY = LoaderProxy();
  window.Sprite.load = Sprite.load;
})(jQuery);



/*
 * jQuery Hotkeys Plugin
 * Copyright 2010, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 * Based upon the plugin by Tzury Bar Yochay:
 * http://github.com/tzuryby/hotkeys
 *
 * Original idea by:
 * Binny V A, http://www.openjs.com/scripts/events/keyboard_shortcuts/
*/
(function($){

    jQuery.hotkeys = {
        version: "0.8+",

        specialKeys: {
            8: "backspace", 9: "tab", 13: "return", 16: "shift", 17: "ctrl", 18: "alt", 19: "pause",
            20: "capslock", 27: "esc", 32: "space", 33: "pageup", 34: "pagedown", 35: "end", 36: "home",
            37: "left", 38: "up", 39: "right", 40: "down", 45: "insert", 46: "del",
            96: "0", 97: "1", 98: "2", 99: "3", 100: "4", 101: "5", 102: "6", 103: "7",
            104: "8", 105: "9", 106: "*", 107: "+", 109: "-", 110: ".", 111 : "/",
            112: "f1", 113: "f2", 114: "f3", 115: "f4", 116: "f5", 117: "f6", 118: "f7", 119: "f8",
            120: "f9", 121: "f10", 122: "f11", 123: "f12", 144: "numlock", 145: "scroll", 188: ",", 190: ".",
            191: "/", 224: "meta"
        },

        shiftNums: {
            "`": "~", "1": "!", "2": "@", "3": "#", "4": "$", "5": "%", "6": "^", "7": "&",
            "8": "*", "9": "(", "0": ")", "-": "_", "=": "+", ";": ": ", "'": "\"", ",": "<",
            ".": ">",  "/": "?",  "\\": "|"
        }
    };

    function keyHandler( handleObj ) {

        var origHandler = handleObj.handler,
            //use namespace as keys so it works with event delegation as well
            //will also allow removing listeners of a specific key combination
            //and support data objects
            keys = (handleObj.namespace || "").toLowerCase().split(" ");
            keys = jQuery.map(keys, function(key) { return key.split("."); });

        //no need to modify handler if no keys specified
        if (keys.length === 1 && (keys[0] === "" || keys[0] === "autocomplete")) {
            return;
        }

        handleObj.handler = function( event ) {
            // Don't fire in text-accepting inputs that we didn't directly bind to
            // important to note that $.fn.prop is only available on jquery 1.6+
            if ( this !== event.target && (/textarea|select/i.test( event.target.nodeName ) ||
                event.target.type === "text" || jQuery(event.target).prop('contenteditable') == 'true' )) {
                return;
            }

            // Keypress represents characters, not special keys
            var special = event.type !== "keypress" && jQuery.hotkeys.specialKeys[ event.which ],
                character = String.fromCharCode( event.which ).toLowerCase(),
                key, modif = "", possible = {};

            // check combinations (alt|ctrl|shift+anything)
            if ( event.altKey && special !== "alt" ) {
              modif += "alt_";
            }

            if ( event.ctrlKey && special !== "ctrl" ) {
              modif += "ctrl_";
            }

            // TODO: Need to make sure this works consistently across platforms
            if ( event.metaKey && !event.ctrlKey && special !== "meta" ) {
              modif += "meta_";
            }

            if ( event.shiftKey && special !== "shift" ) {
              modif += "shift_";
            }

            if ( special ) {
              possible[ modif + special ] = true;

            } else {
              possible[ modif + character ] = true;
              possible[ modif + jQuery.hotkeys.shiftNums[ character ] ] = true;

              // "$" can be triggered as "Shift+4" or "Shift+$" or just "$"
              if ( modif === "shift_" ) {
                possible[ jQuery.hotkeys.shiftNums[ character ] ] = true;
              }
            }

            for ( var i = 0, l = keys.length; i < l; i++ ) {
              if ( possible[ keys[i] ] ) {
                return origHandler.apply( this, arguments );
              }
            }
        };
    }

    jQuery.each([ "keydown", "keyup", "keypress" ], function() {
        jQuery.event.special[ this ] = { add: keyHandler };
    });

})(jQuery);